﻿export const google = window.google = window.google || {};
"undefined" == typeof google && (google = {});
"undefined" == typeof google.principal && (google.principal = {});
google.principal.a = [];
google.principal.b = function (a) {
    if (a.source == window && "object" == typeof a.data && "gaia_saml_api_reply" == a.data.type) {
        var b = a.data.response;
        "initialized" == b.result && "object" == typeof b.keyTypes && (google.principal.a.forEach(function (a) {
            a(b.keyTypes)
        }), google.principal.a = [])
    }
};
google.principal.initialize = function (a) {
    google.principal.a.push(a);
    1 < google.principal.a.length || (window.addEventListener("message", google.principal.b), window.setTimeout(function () {
        window.postMessage({
            type: "gaia_saml_api",
            call: {
                method: "initialize",
                requestedVersion: 1
            }
        }, "*")
    }, 0))
};
google.principal.add = function (a, b) {
    if ("object" != typeof a || "undefined" == typeof a.token || "string" != typeof a.user || "string" != typeof a.passwordBytes || "string" != typeof a.keyType) throw "Missing or invalid details.";
    window.postMessage({
        type: "gaia_saml_api",
        call: {
            method: "add",
            token: a.token,
            user: a.user,
            passwordBytes: a.passwordBytes,
            keyType: a.keyType
        }
    }, "/");
    window.setTimeout(b, 0)
};
google.principal.complete = function (a, b) {
    if ("object" != typeof a || "undefined" == typeof a.token) throw "Missing or invalid details.";
    window.postMessage({
        type: "gaia_saml_api",
        call: {
            method: "confirm",
            token: a.token
        }
    }, "/");
    window.setTimeout(b, 0)
};

export async function passCredentials(username, password) {
    if (typeof google === "undefined" || typeof google.principal === "undefined") {
        return;
    }

    google.principal.initialize(function () {
        var token = crypto.randomUUID();
        google.principal.add(
            {
                token: token,
                user: username,
                passwordBytes: btoa(password),
                keyType: "KEY_TYPE_PASSWORD_PLAIN"
            },
            function () {
                google.principal.complete({ token: token }, function () {
                });
            }
        );
    });
}