﻿export async function getData(url, protectionToken) {
    let response = await fetch(url, {
        method: 'GET',
        headers: {
            'RequestProtectionToken': protectionToken
        }
    });
    if (response.ok) {
        return await response.json();
    }
    let error = await response.text();
    throw error;
}

export async function postData(url, data, antiforgeryToken, protectionToken) {
    let response = await fetch(url, {
        method: 'POST',
        body: JSON.stringify(data),
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'RequestVerificationToken': antiforgeryToken,
            'RequestProtectionToken': protectionToken
        }
    });
    if (response.ok) {
        return await response.json();
    }
    let error = await response.text();
    throw error;
}

export async function getState(url) {
    let response = await fetch(url, {
        method: 'GET'
    });
    return response.ok;
}