﻿function showModalDialog(dialogId) {
    let modal = new bootstrap.Modal(document.getElementById(dialogId), { backdrop: 'static', keyboard: false });
    if (modal) {
        modal.show();
    }
}

function hideModalDialog(dialogId) {
    var modal = bootstrap.Modal.getInstance(document.getElementById(dialogId));
    if (modal != null) {
        modal.hide();
    }
}

function downloadFile(filename, content) {
    var link = document.createElement('a');
    link.download = filename;
    link.href = "data:text/plain;charset=utf-8," + encodeURIComponent(content)
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function saveAsFile(filename, byteBase64) {
    var link = document.createElement('a');
    link.download = filename;
    link.href = "data:application/octet-stream;base64," + byteBase64;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function getTimeZone() {
    return Intl.DateTimeFormat().resolvedOptions().timeZone;
}

function isChromeOS() {
    return navigator.userAgent.includes("CrOS");
}

function isMobileDevice() {
    return /android|iphone|ipad/i.test(navigator.userAgent);
}

function drawSummaryChart(id, items, colors) {
    const config = {
        type: 'doughnut',
        data: {
            datasets: [{
                data: items,
                backgroundColor: colors,
                borderColor: 'rgb(255, 255, 255)', // White color for separations
                borderWidth: 2, // Thickness of the dividing border
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, // Disable fixed aspect ratio
            plugins: {
                legend: {
                    display: false // Removing the legend
                },
                tooltip: {
                    enabled: false // Removing tooltips
                }
            },
            cutout: '65%'
        }
    };

    const ctx = document.getElementById(id);

    new Chart(ctx, config);
}

function enforceKeepAlive() {
    const ctx = new (window.AudioContext || window.webkitAudioContext)();
    ctx.resume();

    const osc = ctx.createOscillator();
    osc.type = "sine";
    osc.frequency.value = 0;

    const gain = ctx.createGain();
    gain.gain.value = 1;

    const dest = ctx.createMediaStreamDestination();
    osc.connect(gain);
    gain.connect(dest);

    const audio = document.createElement("audio");
    audio.controls = false;
    audio.autoplay = true;
    audio.srcObject = dest.stream;

    document.body.appendChild(audio);

    audio.play();
    osc.start();

    setTimeout(() => {
        osc.stop();
        audio.pause();
        audio.srcObject = null;
        audio.remove();
        ctx.close();
    }, 45_000);
}